package eu.shiftforward.adstax.ups.api
/**
 * Domain exception for User errors
 * @param error the domain error
 */
case class UserException(error: UserError) extends Exception(error.message)
/**
 * User domain error
 */
sealed trait UserError {
  /**
   * Description message for the error
   */
  def message: String
}
/**
 * A error for when a UserId is invalid
 * @param userId the userId to validate
 */
case class InvalidUserId(userId: UserId) extends UserError {
  def message = s"Invalid UserId with id type ${userId.idType} and id ${userId.id} found."
}
