package eu.shiftforward.adstax.config

import scala.concurrent.duration._

import pureconfig.ConfigReader
import pureconfig.generic.semiauto._

case class RabbitMQ(
    host: String,
    port: Int,
    username: String,
    password: String,
    timeout: FiniteDuration,
    cfMessageTtl: Option[FiniteDuration] = None,
    cfQueueTtl: Option[FiniteDuration] = None)

object RabbitMQ {
  case class Binding(
      exchangeName: String,
      routingKey: String,
      queueName: Option[String] = None)

  object Binding {
    implicit val rabbitMQBindingReader: ConfigReader[Binding] = deriveReader[Binding]
  }

  case class Complete(
      rabbitmq: RabbitMQ,
      binding: RabbitMQ.Binding)

  object Complete {
    implicit val rabbitMQCompleteReader: ConfigReader[RabbitMQ.Complete] = deriveReader[RabbitMQ.Complete]
  }

  implicit val rabbitMQReader: ConfigReader[RabbitMQ] = deriveReader[RabbitMQ]
}
