package eu.shiftforward.adstax.ups.api

import io.circe.Json

/**
 * A response from the User Profile Storage module to a [[UserProfileStorageRequest]].
 */
sealed trait UserProfileStorageResponse

/**
 * The response for a [[GetUser]] request.
 *
 * @param data the attributes and computed attributes values associated with the user wrapped in a `Some`
 *             if the user exists, `None` otherwise.
 */
case class GetUserResponse(data: Option[UserData]) extends UserProfileStorageResponse

/**
 * The response for a [[GetIds]] request.
 */
case class GetIdsResponse(ids: Set[UserId]) extends UserProfileStorageResponse

/**
 * The response for a [[GetIdsAndData]] request.
 *
 * @param ids the set of ids associated with the user
 * @param data the attributes and computed attributes values associated with the user wrapped in a `Some`
 *             if the user exists, `None` otherwise.
 */
case class GetIdsAndDataResponse(ids: Set[UserId], data: Option[UserData]) extends UserProfileStorageResponse

/**
 * The response for a [[GetUserBaseAttribute]] or a [[GetUserComputedAttribute]] request.
 *
 * @param attributeValue the attribute value for the requested key wrapped in a `Some` if the user and the attribute
 * exists, `None` otherwise
 */
case class GetUserAttributeResponse(attributeValue: Option[Json]) extends UserProfileStorageResponse

/**
 * The response for an [[UpdateUser]] request.
 */
case object UpdateUserResponse extends UserProfileStorageResponse

/**
 * The response for a [[DeleteUser]] request.
 */
case object DeleteUserResponse extends UserProfileStorageResponse

/**
 * The response for a [[DeleteUserAttribute]] request.
 */
case object DeleteUserAttributeResponse extends UserProfileStorageResponse

/**
 * The response for a [[LinkUsers]] request.
 */
case object LinkUsersResponse extends UserProfileStorageResponse

/**
 * The response for a [[SetMergeStrategy]] request.
 */
case object SetMergeStrategyResponse extends UserProfileStorageResponse

/**
 * The response for a [[ResetLinks]] request.
 */
case object ResetLinksResponse extends UserProfileStorageResponse
