package eu.shiftforward.adstax.recommender.api

import scala.concurrent.Future

/**
 * Interface for clients capable of interacting with the Recommender module for retrieving recommendations for users or
 * other products.
 */
trait RecommenderClient {

  /**
   * Obtains a recommendation for a user.
   *
   * @param userId the identifier of the user
   * @param clientId the identifier of the client
   * @param siteId the identifier of the site
   * @return a `Future` with the [[Recommendation]] wrapped in a `Some` if it exists, `None` otherwise.
   */
  def getRecommendationForUser(
    userId: String,
    clientId: Option[String],
    siteId: Option[String]): Future[Option[Recommendation]]

  /**
   * Obtains a recommendation for a product.
   *
   * @param productId the identifier of the product
   * @param clientId the identifier of the client
   * @param siteId the identifier of the site
   * @return a `Future` with the [[Recommendation]] wrapped in a `Some` if it exists, `None` otherwise.
   */
  def getRecommendationForProduct(
    productId: String,
    clientId: Option[String],
    siteId: Option[String]): Future[Option[Recommendation]]
}
