package eu.shiftforward.adstax.ups.api

import spray.json.DefaultJsonProtocol._

/**
 * A response from the User Profile Storage module to a [[UserProfileStorageRequest]].
 */
sealed trait UserProfileStorageResponse

/**
 * The response for a [[GetUser]] request.
 *
 * @param attributes the attributes associated with the user wrapped in a `Some` if the user exists, `None` otherwise
 */
case class GetUserResponse(attributes: Option[UserAttributes]) extends UserProfileStorageResponse

object GetUserResponse {
  implicit val getResponseFormat = jsonFormat1(GetUserResponse.apply)
}

/**
 * The response for a [[GetUserAttribute]] request.
 *
 * @param attributeValue the attribute value for the requested key wrapped in a `Some` if the user and the attribute
 * exists, `None` otherwise
 */
case class GetUserAttributeResponse(attributeValue: Option[AttributeValue]) extends UserProfileStorageResponse

object GetUserAttributeResponse {
  implicit val getAttributeResponseFormat = jsonFormat1(GetUserAttributeResponse.apply)
}

/**
 * The response for an [[UpdateUser]] request.
 */
case object UpdateUserResponse extends UserProfileStorageResponse {
  implicit val updateResponseFormat = jsonFormat0(() => UpdateUserResponse)
}

/**
 * The response for a [[DeleteUser]] request.
 */
case object DeleteUserResponse extends UserProfileStorageResponse {
  implicit val deleteResponseFormat = jsonFormat0(() => DeleteUserResponse)
}

/**
 * The response for a [[DeleteUserAttribute]] request.
 */
case object DeleteUserAttributeResponse extends UserProfileStorageResponse {
  implicit val deleteAttributeResponseFormat = jsonFormat0(() => DeleteUserAttributeResponse)
}

/**
 * The response for a [[LinkUsers]] request.
 */
case object LinkUsersResponse extends UserProfileStorageResponse {
  implicit val linkResponseFormat = jsonFormat0(() => LinkUsersResponse)
}

/**
 * The response for a [[ResetLinks]] request.
 */
case object ResetLinksResponse extends UserProfileStorageResponse {
  implicit val resetLinksResponseFormat = jsonFormat0(() => ResetLinksResponse)
}
