package eu.shiftforward.adstax.productfeeder.api.rpc

import eu.shiftforward.adstax.productfeeder.api._
import eu.shiftforward.adstax.util.rpc.TypeDescriptor

/**
 * The set of type descriptors describing the expected responses for each type of Product Feeder request in RPC and
 * attributing AMQP routing keys for each request type.
 */
object TypeDescriptors {
  implicit val getTypeDescriptor = TypeDescriptor[GetProduct, GetProductResponse]("getproduct.json")
  implicit val updateTypeDescriptor = TypeDescriptor[UpdateProduct, UpdateProductResponse]("updateproduct.json")
  implicit val deleteTypeDescriptor = TypeDescriptor[DeleteProduct, DeleteProductResponse]("deleteproduct.json")
  implicit val downloadFeedRoutingKey = TypeDescriptor[DownloadFeed, DownloadFeedResponse]("downloadfeed.json")
}
