package eu.shiftforward.adstax.productfeeder.api

import spray.json.DefaultJsonProtocol._

/**
 * A response from the Product Feeder module to a [[ProductFeederRequest]].
 */
sealed trait ProductFeederResponse

/**
 * The response for a [[GetProduct]] request.
 *
 * @param productResult a product item wrapped a `Some` if a matching product was found, `None` otherwise
 */
case class GetProductResponse(productResult: Option[ProductItem]) extends ProductFeederResponse

object GetProductResponse {
  implicit val getProductResponseFormat = jsonFormat1(GetProductResponse.apply)
}

/**
 * The response for an [[UpdateProduct]] request.
 *
 * @param clientId the identifier of the client
 * @param siteId the optional identifier of the site
 * @param product the updated product information
 */
case class UpdateProductResponse(clientId: String, siteId: String, product: ProductItem)
  extends ProductFeederResponse

object UpdateProductResponse {
  implicit val updateProductResponseFormat = jsonFormat3(UpdateProductResponse.apply)
}

/**
 * The response for an [[DeleteProduct]] request.
 *
 * @param clientId the identifier of the client
 * @param siteId the optional identifier of the site
 * @param productId the identifier of the product
 */
case class DeleteProductResponse(clientId: String, siteId: String, productId: String)
  extends ProductFeederResponse

object DeleteProductResponse {
  implicit val deleteProductResponseFormat = jsonFormat3(DeleteProductResponse.apply)
}

/**
 * The response for an [[DownloadFeed]] request.
 *
 * @param productCount the number of inserted products
 * @param msg an optional message describing the success of the operation
 */
case class DownloadFeedResponse(productCount: Int, msg: Option[String] = None) extends ProductFeederResponse

object DownloadFeedResponse {
  implicit val downloadFeedResponseFormat = jsonFormat2(DownloadFeedResponse.apply)
}
