package eu.shiftforward.adstax.recommender.api

import spray.json.DefaultJsonProtocol._

/**
 * A request to be sent to the Recommender module.
 */
sealed trait RecommenderRequest

/**
 * A request to obtain a recommendation.
 *
 * @param query the query definition for the recommendation
 */
case class GetRecommendation(query: RecommendationQuery) extends RecommenderRequest

object GetRecommendation {
  implicit val getRecommendationJsonFormat = jsonFormat1(GetRecommendation.apply)
}
