package eu.shiftforward.adstax.ups.api

import spray.json.DefaultJsonProtocol._

/**
 * A structure containing all the attributes of a user.
 *
 * @param baseAttributes the base attribute set of the user
 * @param computedAttributes the computed attributes of the user
 */
case class UserData(
    baseAttributes: UserAttributes,
    computedAttributes: UserAttributes)

object UserData {

  /**
   * The empty set of user data.
   */
  val empty = UserData(UserAttributes.empty, UserAttributes.empty)

  implicit val userDataFormat = jsonFormat2(UserData.apply)
}
