package eu.shiftforward.adstax.productfeeder.api

import spray.json.DefaultJsonProtocol._

/**
 * A product query to be sent to the Product Feeder module.
 *
 * @param clientId the id of the client
 * @param siteId optinal site id, if none the query will search for the product at a client level
 * @param productId the id of the product
 */
case class ProductQuery(clientId: String, siteId: String, productId: String)

object ProductQuery {
  implicit val productQueryJsonFormat = jsonFormat3(ProductQuery.apply)
}
