package eu.shiftforward.adstax.util.rpc

/**
 * An evidence that RPC requests of type `Req` should be sent through `routingKey` and a response of type `Resp` is
 * expected.
 *
 * @tparam Req the type of the request
 * @tparam Resp the type of the response
 */
trait TypeDescriptor[Req, Resp] {

  /**
   * The AMQP routing key through which requests and responses should be exchanged
   */
  def routingKey: String
}

object TypeDescriptor {
  def apply[Req, Resp](_routingKey: String) = new TypeDescriptor[Req, Resp] { def routingKey = _routingKey }
}
