package eu.shiftforward.adstax.scheduler.api.rpc

import eu.shiftforward.adstax.scheduler.api._
import eu.shiftforward.adstax.util.rpc.TypeDescriptor

/**
 * The set of type descriptors describing the expected responses for each type of Scheduler request in RPC and
 * attributing AMQP routing keys for each request type.
 */
object TypeDescriptors {
  implicit val scheduleTypeDescriptor = TypeDescriptor[Schedule, ScheduleResponse]("schedulerequest.json")
  implicit val cancelTypeDescriptor = TypeDescriptor[Cancel, CancelResponse]("cancelrequest.json")
  implicit val getJobsStatusTypeDescriptor = TypeDescriptor[GetJobsStatus.type, JobsStatusResponse]("getstatusrequest.json")
  implicit val getJobStatusTypeDescriptor = TypeDescriptor[GetJobStatus, JobStatusResponse]("getjobstatusrequest.json")
}
