package eu.shiftforward.adstax.config

import scala.concurrent.duration._

case class RabbitMQ(
  host: String,
  port: Int,
  username: String,
  password: String,
  timeout: FiniteDuration,
  cfMessageTtl: Option[FiniteDuration] = None,
  cfQueueTtl: Option[FiniteDuration] = None)

object RabbitMQ {
  case class Binding(
    exchangeName: String,
    routingKey: String,
    queueName: Option[String] = None)
}
