package eu.shiftforward.adstax.util

import scala.reflect.runtime.universe._
import scala.util.Try

/**
 * Utilities for loading objects and instantiate classes using reflection.
 */
object InstanceLoader {
  private[this] val m = runtimeMirror(getClass.getClassLoader)

  /**
   * Returns an instance of a given type obtained via reflection. If the specified class name refers to a companion
   * object, i.e. it ends with `$`, the object is returned. Otherwise, if the specified class has a default
   * constructor, a new instance is created that way.
   *
   * @param className the fully qualified name of the class
   * @tparam A the type of the class being loaded
   * @return an instance of `A` obtained via reflection and wrapped in a `Some`, or `None` if it couldn't be obtained.
   */
  def getInstance[A](className: String): Option[A] = Try {
    if (className.endsWith("$")) m.reflectModule(m.staticModule(className.init)).instance.asInstanceOf[A]
    else Class.forName(className).newInstance().asInstanceOf[A]
  }.toOption
}
