package eu.shiftforward.adstax.ups.api

import spray.json.DefaultJsonProtocol._
import spray.json._

import eu.shiftforward.apso.Implicits._

/**
 * The attribute set of a user.
 *
 * @param attributes the map from attribute names to values
 */
case class UserAttributes(attributes: Map[String, AttributeValue]) {

  /**
   * Converts this attribute set to a native Scala collection.
   *
   * @return a native Scala collection containing the attribute set.
   */
  def toSymbolTable: Map[String, Any] =
    attributes.mapValues(_.value)

  /**
   * Merges this attribute set with another. The merge is performed attribute by attribute using their `merge` method,
   * with the attribute set passed as argument having precedence over this one.
   *
   * @param that the attribute set to merge with this one
   * @return the merged attribute set.
   */
  def merge(that: UserAttributes): UserAttributes =
    UserAttributes(this.attributes.twoWayMerge(that.attributes)(_ merge _))
}

object UserAttributes {

  /**
   * The empty set of user attributes.
   */
  val empty = UserAttributes(Map.empty)

  implicit object UserAttributesJsonFormat extends RootJsonFormat[UserAttributes] {
    def write(ua: UserAttributes) = ua.attributes.toJson
    def read(value: JsValue) = UserAttributes(value.convertTo[Map[String, AttributeValue]])
  }
}
