package eu.shiftforward.adstax.ups.api.rpc

import eu.shiftforward.adstax.ups.api._
import eu.shiftforward.adstax.util.rpc.TypeDescriptor

/**
 * The set of type descriptors describing the expected responses for each type of User Profile Storage request in RPC
 * and attributing AMQP routing keys for each request type.
 */
object TypeDescriptors {
  implicit val getTypeDescriptor = TypeDescriptor[GetUser, GetUserResponse]("get.json")
  implicit val getAttributeTypeDescriptor = TypeDescriptor[GetUserAttribute, GetUserAttributeResponse]("get-attribute.json")
  implicit val updateTypeDescriptor = TypeDescriptor[UpdateUser, UpdateUserResponse.type]("update.json")
  implicit val deleteTypeDescriptor = TypeDescriptor[DeleteUser, DeleteUserResponse.type]("delete.json")
  implicit val deleteAttributeTypeDescriptor = TypeDescriptor[DeleteUserAttribute, DeleteUserAttributeResponse.type]("delete-attribute.json")
  implicit val linkTypeDescriptor = TypeDescriptor[LinkUsers, LinkUsersResponse.type]("link.json")
  implicit val getIdsTypeDescriptor = TypeDescriptor[GetIds, GetIdsResponse]("get-ids.json")
  implicit val resetTypeDescriptor = TypeDescriptor[ResetLinks, ResetLinksResponse.type]("reset-links.json")
}
