package eu.shiftforward.adstax.scheduler.api

import spray.json._

sealed trait MissedExecutionBehavior {
  def name: String
}

case object Continue extends MissedExecutionBehavior {
  val name = "continue"
}

case object ExecuteAll extends MissedExecutionBehavior {
  val name = "executeAll"
}

object MissedExecutionBehavior {

  implicit object MissedExecutionBehaviorJsonFormat extends JsonFormat[MissedExecutionBehavior] {

    def write(obj: MissedExecutionBehavior): JsValue = JsString(obj.name)

    def read(json: JsValue): MissedExecutionBehavior = json match {
      case JsString("continue") => Continue
      case JsString("executeAll") => ExecuteAll
      case JsString(other) =>
        deserializationError(s"Impossible to read MissedExecutionBehavior: unexpected value '$other'!")
      case _ =>
        deserializationError("Impossible to read MissedExecutionBehavior: unexpected JSON type!")
    }
  }
}
