package eu.shiftforward.adstax.productfeeder.api

import spray.json._

sealed trait MimeType
case object JSON extends MimeType
case object XML extends MimeType

object MimeType {

  implicit object MimeTypeJsonFormat extends JsonFormat[MimeType] {

    def read(json: JsValue) = json match {
      case JsString("JSON") => JSON
      case JsString("XML") => XML
      case mimeType => deserializationError(s"Invalid MIME type: ${mimeType.compactPrint}")
    }

    def write(obj: MimeType) = obj match {
      case JSON => JsString("JSON")
      case XML => JsString("XML")
    }
  }
}
