package eu.shiftforward.adstax.scheduler.api.rpc

import akka.actor.ActorRefFactory
import pureconfig.syntax._
import spray.json.RootJsonFormat

import eu.shiftforward.adstax.config
import eu.shiftforward.adstax.config.ConfigConvertProtocol._
import eu.shiftforward.adstax.scheduler.api._
import eu.shiftforward.adstax.scheduler.api.job.SchedulerJob
import eu.shiftforward.adstax.scheduler.api.job.SchedulerJob.SchedulerJobJsonFormat
import eu.shiftforward.adstax.scheduler.api.rpc.TypeDescriptors._
import eu.shiftforward.adstax.util.AmqpClient
import eu.shiftforward.adstax.util.rpc.AmqpRpcJsonClient
import eu.shiftforward.apso.config.LazyConfigFactory

/**
 * The AMQP RPC Client to interact with the Scheduler.
 */
class SchedulerAmqpRpcClient(val amqp: AmqpClient, val rpcConfig: config.RpcClient)(implicit sjjf: RootJsonFormat[SchedulerJob])
    extends SchedulerClient with AmqpRpcJsonClient {

  def scheduleAction(action: SchedulerJob) = dispatchRequest(Schedule(action)).map(_.status)
  def cancelAction(id: String) = dispatchRequest(Cancel(id)).map(_.status)
  def getJobsStatus = dispatchRequest(GetJobsStatus).map(_.jobs)
  def getJobStatus(id: String) = dispatchRequest(GetJobStatus(id)).map(_.status)
}

object SchedulerAmqpRpcClient {

  def apply(amqp: AmqpClient, rpcConfig: config.RpcClient, jobTypes: Map[String, String]): SchedulerAmqpRpcClient = {
    implicit val schedulerJobJsonFormat: SchedulerJobJsonFormat = new SchedulerJob.SchedulerJobJsonFormat(jobTypes)
    new SchedulerAmqpRpcClient(amqp, rpcConfig)
  }

  def apply(
    amqpConfig: config.RabbitMQ = LazyConfigFactory.load.getConfig("adstax.sdk.scheduler.rabbitmq").to[config.RabbitMQ].get,
    rpcConfig: config.RpcClient = LazyConfigFactory.load.getConfig("adstax.sdk.scheduler.rpc").to[config.RpcClient].get,
    jobTypes: Map[String, String] = LazyConfigFactory.load.getConfig("adstax.sdk.scheduler.job-types").to[Map[String, String]].get)(
    implicit
    actorRefFactory: ActorRefFactory): SchedulerAmqpRpcClient = {

    implicit val schedulerJobJsonFormat: SchedulerJobJsonFormat = new SchedulerJob.SchedulerJobJsonFormat(jobTypes)
    new SchedulerAmqpRpcClient(new AmqpClient(amqpConfig, "adstax-scheduler-sdk"), rpcConfig)
  }
}
