package eu.shiftforward.adstax.recommender.api

import spray.json.DefaultJsonProtocol._

/**
 * A response from the Recommender module to a [[RecommenderRequest]].
 */
sealed trait RecommenderResponse

/**
 * The response for a [[GetRecommendation]] request.
 *
 * @param recommendation a recommendation wrapped a `Some` if a recommendation was available, `None` otherwise
 */
case class GetRecommendationResponse(recommendation: Option[Recommendation]) extends RecommenderResponse

object GetRecommendationResponse {
  implicit val getRecommendationResultFormat = jsonFormat1(GetRecommendationResponse.apply)
}
