package eu.shiftforward.adstax.recommender.api

import spray.json._

/**
 * A product recommendation.
 *
 * @param userId the identifier of the queried user wrapped in a `Some` if the recommendation is for a user, `None`
 *               otherwise
 * @param productId the identifier of the queried product wrapped in a `Some` if the recommendation is for a product,
 *                  `None` otherwise
 * @param clientId the identifier of the client
 * @param siteId the identifier of the site
 * @param recommendedProductIds the recommended product identifiers
 * @param timestamp the time the recommendation was issued
 */
case class Recommendation(
  userId: Option[String],
  productId: Option[String],
  clientId: Option[String] = None,
  siteId: Option[String] = None,
  recommendedProductIds: Seq[String] = List.empty,
  timestamp: Option[String] = None)

object Recommendation {

  def getId(r: Recommendation): String = Recommendation.getId(r.userId, r.productId)

  def getId(userId: Option[String], productId: Option[String]): String = (userId, productId).toString

  private[this] object JsonProtocol extends DefaultJsonProtocol with NullOptions {
    def recommendationJsonFormat = jsonFormat6(Recommendation.apply)
  }

  implicit val recommendationJsonFormat = JsonProtocol.recommendationJsonFormat
}
