package eu.shiftforward.adstax.productfeeder.api.rpc

import akka.actor.ActorRefFactory
import pureconfig.syntax._

import eu.shiftforward.adstax.config
import eu.shiftforward.adstax.config.ConfigConvertProtocol._
import eu.shiftforward.adstax.productfeeder.api._
import eu.shiftforward.adstax.productfeeder.api.rpc.TypeDescriptors._
import eu.shiftforward.adstax.util.AmqpClient
import eu.shiftforward.adstax.util.rpc.AmqpRpcJsonClient
import eu.shiftforward.apso.config.LazyConfigFactory

/**
 * The AMQP RPC Client to interact with the Product Feeder.
 */
class ProductFeederAmqpRpcClient(val amqp: AmqpClient, val rpcConfig: config.RpcClient)
    extends ProductFeederClient with AmqpRpcJsonClient {

  def getProduct(clientId: String, siteId: String, productId: String) =
    dispatchRequest(GetProduct(ProductQuery(clientId, siteId, productId))).map(_.productResult)

  def updateProduct(clientId: String, siteId: String, productId: String, productAttributes: Map[String, Any]) =
    dispatchRequest(UpdateProduct(clientId, siteId, ProductItem(productId, productAttributes))).map(_ => true)

  def deleteProduct(clientId: String, siteId: String, productId: String) =
    dispatchRequest(DeleteProduct(clientId, siteId, productId)).map(_ => true)
}

object ProductFeederAmqpRpcClient {

  def apply(amqp: AmqpClient, rpcConfig: config.RpcClient): ProductFeederAmqpRpcClient =
    new ProductFeederAmqpRpcClient(amqp, rpcConfig)

  def apply(
    amqpConfig: config.RabbitMQ = LazyConfigFactory.load.getConfig("adstax.sdk.product-feeder.rabbitmq").to[config.RabbitMQ].get,
    rpcConfig: config.RpcClient = LazyConfigFactory.load.getConfig("adstax.sdk.product-feeder.rpc").to[config.RpcClient].get)(
    implicit
    actorRefFactory: ActorRefFactory): ProductFeederAmqpRpcClient = {

    new ProductFeederAmqpRpcClient(new AmqpClient(amqpConfig, "adstax-product-feeder-sdk"), rpcConfig)
  }
}
