package eu.shiftforward.adstax.ups.api

import spray.json.DefaultJsonProtocol._

/**
 * A response from the User Profile Storage module to a [[UserProfileStorageRequest]].
 */
sealed trait UserProfileStorageResponse

/**
 * The response for a [[GetUser]] request.
 *
 * @param attributes the attributes associated with the user wrapped in a `Some` if the user exists, `None` otherwise
 */
case class GetUserResponse(attributes: Option[UserAttributes]) extends UserProfileStorageResponse

object GetUserResponse {
  implicit val getResponseFormat = jsonFormat1(GetUserResponse.apply)
}

/**
 * The response for an [[UpdateUser]] request.
 *
 * @param success `true` of the operation was successful, `false` otherwise
 */
case class UpdateUserResponse(success: Boolean) extends UserProfileStorageResponse

object UpdateUserResponse {
  implicit val updateResponseFormat = jsonFormat1(UpdateUserResponse.apply)
}

/**
 * The response for a [[DeleteUser]] request.
 *
 * @param success `true` of the operation was successful, `false` otherwise
 */
case class DeleteUserResponse(success: Boolean) extends UserProfileStorageResponse

object DeleteUserResponse {
  implicit val deleteResponseFormat = jsonFormat1(DeleteUserResponse.apply)
}
