package eu.shiftforward.adstax.scheduler.api

import spray.json.DefaultJsonProtocol._

/**
 * A response from the Scheduler module to a [[SchedulerRequest]].
 */
trait SchedulerResponse

/**
 * The response to a [[Schedule]] request.
 *
 * @param status the status of the scheduled job
 */
case class ScheduleResponse(status: JobStatus) extends SchedulerResponse

object ScheduleResponse {
  implicit val scheduleResponseFormat = jsonFormat1(ScheduleResponse.apply)
}

/**
 * The response to a [[Cancel]] request.
 *
 * @param status the status of the cancelled job
 */
case class CancelResponse(status: JobStatus) extends SchedulerResponse

object CancelResponse {
  implicit val cancelResponseFormat = jsonFormat1(CancelResponse.apply)
}

/**
 * The response to a [[GetJobsStatus]] request.
 *
 * @param jobs a map from job identifiers to their statuses
 */
case class JobsStatusResponse(jobs: Map[String, JobStatus]) extends SchedulerResponse

object JobsStatusResponse {
  implicit val jobsStatusResponseFormat = jsonFormat1(JobsStatusResponse.apply)
}

/**
 * The response to a [[GetJobStatus]] request.
 *
 * @param status the status of the requested job
 */
case class JobStatusResponse(status: Option[JobStatus]) extends SchedulerResponse

object JobStatusResponse {
  implicit val jobStatusResponseFormat = jsonFormat1(JobStatusResponse.apply)
}
