package eu.shiftforward.adstax.scheduler.api

import fommil.sjs.FamilyFormats._
import spray.json.RootJsonFormat

import eu.shiftforward.adstax.scheduler.api.job.SchedulerJob

/**
 * The status of a job in the Scheduler module.
 */
sealed trait JobStatus

/**
 * Job status indicating a successfully scheduled job.
 *
 * @param job the scheduled job
 */
case class Scheduled(job: SchedulerJob) extends JobStatus

/**
 * Job status indicating a cancelled job.
 */
case object Cancelled extends JobStatus

object JobStatus {

  implicit private[this] val jobStatusCoproductHint = new FlatCoproductHint[JobStatus]("status") {
    override protected def fieldName(orig: String) = orig.toLowerCase
  }

  implicit val jobStatusFormat: RootJsonFormat[JobStatus] = familyFormat
}
