package eu.shiftforward.adstax.util.rpc

import spray.json.DefaultJsonProtocol._
import spray.json._

/**
 * An error occurred as a result of a RPC call.
 *
 * @param message the error message
 */
case class Error(message: String)

object Error {

  implicit object ErrorJsonFormat extends RootJsonFormat[Error] {

    def read(json: JsValue) = json match {
      case JsObject(fields) if fields.contains("type") && fields.contains("message") =>
        (fields("type"), fields("message")) match {
          case (JsString("RpcError"), JsString(message)) => Error(message)
          case (other, _) => deserializationError("Unexpected type: " + other.toString())
        }
      case other => deserializationError("Expected a JsObject with fields 'type' and 'message', got: " + other)
    }

    def write(error: Error) = JsObject(
      "type" -> JsString("RpcError"),
      "message" -> error.message.toJson)
  }
}
