package eu.shiftforward.adstax.ups.api.rpc

import scala.concurrent.Future

import akka.actor.ActorRefFactory
import pureconfig.syntax._

import eu.shiftforward.adstax.config
import eu.shiftforward.adstax.ups.api._
import eu.shiftforward.adstax.ups.api.rpc.TypeDescriptors._
import eu.shiftforward.adstax.util.AmqpClient
import eu.shiftforward.adstax.util.rpc.AmqpRpcJsonClient
import eu.shiftforward.apso.config.LazyConfigFactory

/**
 * The AMQP RPC Client to interact with the User Profile Storage.
 */
class UserProfileStorageAmqpRpcClient(val amqp: AmqpClient, val rpcConfig: config.RpcClient)
    extends UserProfileStorageClient with AmqpRpcJsonClient {

  def get(userId: String, clientId: String) =
    dispatchRequest(GetUser(userId, clientId)).map(_.attributes)

  def update(
    userId: String,
    clientId: String,
    attributes: UserAttributes,
    mergeStrategy: AttributeMergingStrategy = JoinMergingStrategy) =
    dispatchRequest(UpdateUser(userId, clientId, attributes, mergeStrategy)).map(_.success)

  def delete(userId: String, clientId: String): Future[Boolean] =
    dispatchRequest(DeleteUser(userId, clientId)).map(_.success)
}

object UserProfileStorageAmqpRpcClient {

  def apply(amqp: AmqpClient, rpcConfig: config.RpcClient): UserProfileStorageAmqpRpcClient =
    new UserProfileStorageAmqpRpcClient(amqp, rpcConfig)

  def apply(
    amqpConfig: config.RabbitMQ = LazyConfigFactory.load.getConfig("adstax.product-feeder.rabbitmq").to[config.RabbitMQ].get,
    rpcConfig: config.RpcClient = LazyConfigFactory.load.getConfig("adstax.product-feeder.rpc").to[config.RpcClient].get)(
    implicit
    actorRefFactory: ActorRefFactory): UserProfileStorageAmqpRpcClient = {

    new UserProfileStorageAmqpRpcClient(new AmqpClient(amqpConfig, "adstax-product-feeder-sdk"), rpcConfig)
  }
}
