package eu.shiftforward.adstax.ups.api.rpc

import eu.shiftforward.adstax.ups.api._
import eu.shiftforward.adstax.util.rpc.TypeDescriptor

/**
 * The set of type descriptors describing the expected responses for each type of User Profile Storage request in RPC
 * and attributing AMQP routing keys for each request type.
 */
object TypeDescriptors {
  implicit val getTypeDescriptor = TypeDescriptor[GetUser, GetUserResponse]("get.json")
  implicit val updateTypeDescriptor = TypeDescriptor[UpdateUser, UpdateUserResponse]("update.json")
  implicit val deleteTypeDescriptor = TypeDescriptor[DeleteUser, DeleteUserResponse]("delete.json")
}
