package eu.shiftforward.adstax.ups.api

import spray.json.DefaultJsonProtocol._

/**
 * A request to be sent to the User Profile Storage module.
 */
sealed trait UserProfileStorageRequest

/**
 * A request to retrieve information about a user.
 *
 * @param userId the identifier of the user
 * @param clientId the identifier of the client
 */
case class GetUser(userId: String, clientId: String) extends UserProfileStorageRequest

object GetUser {
  implicit val getFormat = jsonFormat2(GetUser.apply)
}

/**
 * A request to update the information about a user.
 *
 * @param userId the identifier of the user
 * @param clientId the identifier of the client
 * @param attributes the attributes to update the user with
 * @param mergeStrategy the strategy to use when merging the attributes
 */
case class UpdateUser(
  userId: String,
  clientId: String,
  attributes: UserAttributes,
  mergeStrategy: AttributeMergingStrategy) extends UserProfileStorageRequest

object UpdateUser {
  implicit val updateFormat = jsonFormat4(UpdateUser.apply)
}

/**
 * A request to delete the information about a user.
 *
 * @param userId the identifier of the user
 * @param clientId the identifier of the client
 */
case class DeleteUser(userId: String, clientId: String) extends UserProfileStorageRequest

object DeleteUser {
  implicit val deleteFormat = jsonFormat2(DeleteUser.apply)
}
