package eu.shiftforward.adstax.scheduler.api.rpc

import akka.actor.ActorRefFactory
import pureconfig.syntax._

import eu.shiftforward.adstax.config
import eu.shiftforward.adstax.scheduler.api._
import eu.shiftforward.adstax.scheduler.api.job.SchedulerJob
import eu.shiftforward.adstax.scheduler.api.rpc.TypeDescriptors._
import eu.shiftforward.adstax.util.AmqpClient
import eu.shiftforward.adstax.util.rpc.AmqpRpcJsonClient
import eu.shiftforward.apso.config.LazyConfigFactory

/**
 * The AMQP RPC Client to interact with the Scheduler.
 */
class SchedulerAmqpRpcClient(val amqp: AmqpClient, val rpcConfig: config.RpcClient)
    extends SchedulerClient with AmqpRpcJsonClient {

  def scheduleAction(action: SchedulerJob) = dispatchRequest(Schedule(action)).map(_.status)
  def cancelAction(id: String) = dispatchRequest(Cancel(id)).map(_.status)
  def getJobsStatus = dispatchRequest(GetJobsStatus).map(_.jobs)
  def getJobStatus(id: String) = dispatchRequest(GetJobStatus(id)).map(_.status)
}

object SchedulerAmqpRpcClient {

  def apply(amqp: AmqpClient, rpcConfig: config.RpcClient): SchedulerAmqpRpcClient =
    new SchedulerAmqpRpcClient(amqp, rpcConfig)

  def apply(
    amqpConfig: config.RabbitMQ = LazyConfigFactory.load.getConfig("adstax.scheduler.rabbitmq").to[config.RabbitMQ].get,
    rpcConfig: config.RpcClient = LazyConfigFactory.load.getConfig("adstax.scheduler.rpc").to[config.RpcClient].get)(
    implicit
    actorRefFactory: ActorRefFactory): SchedulerAmqpRpcClient = {

    new SchedulerAmqpRpcClient(new AmqpClient(amqpConfig, "adstax-scheduler-sdk"), rpcConfig)
  }
}
