package eu.shiftforward.adstax.scheduler.api

import spray.json.DefaultJsonProtocol._

import eu.shiftforward.adstax.scheduler.api.job.SchedulerJob

/**
 * A request to be sent to the Scheduler module.
 */
sealed trait SchedulerRequest

/**
 * A request to schedule a new job.
 *
 * @param job the job to schedule
 */
case class Schedule(job: SchedulerJob) extends SchedulerRequest

object Schedule {
  implicit val scheduleFormat = jsonFormat1(Schedule.apply)
}

/**
 * A request to cancel a previously scheduled job.
 *
 * @param jobId the identifier of the job to cancel
 */
case class Cancel(jobId: String) extends SchedulerRequest

object Cancel {
  implicit val cancelFormat = jsonFormat1(Cancel.apply)
}

/**
 * A request to retrieve the status of all jobs.
 */
case object GetJobsStatus extends SchedulerRequest {
  implicit val getStatusFormat = jsonFormat0(() => GetJobsStatus)
}

/**
 * A request to retrieve the status of a job.
 *
 * @param jobId the identifier of the job whose status is to be retrieved
 */
case class GetJobStatus(jobId: String) extends SchedulerRequest

object GetJobStatus {
  implicit val getJobStatusFormat = jsonFormat1(GetJobStatus.apply)
}
