package eu.shiftforward.adstax.recommender.api.rpc

import akka.actor.ActorRefFactory

import eu.shiftforward.adstax.recommender.api._
import eu.shiftforward.adstax.recommender.api.rpc.TypeDescriptors._
import eu.shiftforward.adstax.util.AmqpClient
import eu.shiftforward.adstax.util.rpc.AmqpRpcJsonClient
import eu.shiftforward.apso.config.LazyConfigFactory
import eu.shiftforward.adstax.config
import pureconfig.syntax._

/**
 * The AMQP RPC Client to interact with the Recommender.
 */
class RecommenderAmqpRpcClient(val amqp: AmqpClient, val rpcConfig: config.RpcClient)
    extends RecommenderClient with AmqpRpcJsonClient {

  def getRecommendationForUser(userId: String, clientId: Option[String], siteId: Option[String]) =
    dispatchRequest(GetRecommendation(UserRecommendationQuery(userId, clientId, siteId))).map(_.recommendation)

  def getRecommendationForProduct(productId: String, clientId: Option[String], siteId: Option[String]) =
    dispatchRequest(GetRecommendation(ProductRecommendationQuery(productId, clientId, siteId))).map(_.recommendation)
}

object RecommenderAmqpRpcClient {

  def apply(amqp: AmqpClient, rpcConfig: config.RpcClient): RecommenderAmqpRpcClient =
    new RecommenderAmqpRpcClient(amqp, rpcConfig)

  def apply(
    amqpConfig: config.RabbitMQ = LazyConfigFactory.load.getConfig("adstax.recommender.rabbitmq").to[config.RabbitMQ].get,
    rpcConfig: config.RpcClient = LazyConfigFactory.load.getConfig("adstax.recommender.rpc").to[config.RpcClient].get)(
    implicit
    actorRefFactory: ActorRefFactory): RecommenderAmqpRpcClient = {

    new RecommenderAmqpRpcClient(new AmqpClient(amqpConfig, "adstax-recommender-sdk"), rpcConfig)
  }
}
