package eu.shiftforward.adstax.storage

import spray.json.DefaultJsonProtocol._

case class UserSegment(id: Option[String] = None, name: Option[String] = None, value: Option[String] = None)

case class UserSegmentsContainer(segments: Set[UserSegment])

object UserSegment {
  object JsonProtocol {
    implicit val userSegmentRootJsonFormat = jsonFormat3(UserSegment.apply)
    implicit val userSegmentsContainerRootJsonFormat = jsonFormat1(UserSegmentsContainer.apply)
  }
}
