package eu.shiftforward.adstax.spark

/**
 * Trait representing a Spark job to run on AdStax. Custom Spark jobs to run on AdStax should implement this trait.
 */
trait SparkJob {
  /**
   * The name of the job to be submitted
   */
  def name: String

  /**
   * The method to run when executing the job. One should assume that the `AdStaxSparkContext` is properly configured
   * and that it is closed at the end of this method call. Closing the context inside the method body is not necessary.
   *
   * @param args the command line arguments supplied to the spark job
   * @param context the `AdStaxSparkContext` to use inside the job
   */
  def run(args: Array[String])(implicit context: AdStaxSparkContext): Unit
}
