package eu.shiftforward.adstax.scheduler.rpc

import eu.shiftforward.adstax.scheduler.action.SchedulerAction
import eu.shiftforward.adstax.scheduler.action.SchedulerAction.JsonProtocol._
import eu.shiftforward.adstax.util.RmqRpcJsonTypeRoutingKey
import spray.json._
import spray.json.DefaultJsonProtocol._

/**
 * Represents a supported operation of the SchedulerRmqRpcActor.
 */
sealed trait SchedulingRequestMessage {
  /**
   * The unique operation type for a concrete SchedulerOperation.
   */
  def operation: String = this.getClass.getSimpleName
}

case class Schedule(action: SchedulerAction) extends SchedulingRequestMessage

object ScheduleTypeRoutingKey extends RmqRpcJsonTypeRoutingKey[Schedule] {
  final val value = "schedulerequest.json"
}

case class Cancel(actionId: String) extends SchedulingRequestMessage

object CancelTypeRoutingKey extends RmqRpcJsonTypeRoutingKey[Cancel] {
  final val value = "cancelrequest.json"
}

trait GetStatus extends SchedulingRequestMessage
case object GetStatus extends GetStatus

object GetStatusTypeRoutingKey extends RmqRpcJsonTypeRoutingKey[GetStatus] {
  final val value = "getstatusrequest.json"
}

case class GetJobStatus(jobId: String) extends SchedulingRequestMessage

object GetJobStatusTypeRoutingKey extends RmqRpcJsonTypeRoutingKey[GetJobStatus] {
  final val value = "getjobstatusrequest.json"
}

object SchedulerOperation {
  object JsonProtocol {
    implicit lazy val scheduleFormat = lazyFormat(jsonFormat(Schedule, "action"))
    implicit lazy val cancelFormat = jsonFormat1(Cancel)
    implicit lazy val getStatusFormat: RootJsonFormat[GetStatus] = jsonFormat0(() => GetStatus)
    implicit lazy val getJobStatusFormat = jsonFormat1(GetJobStatus)
  }
}
