package eu.shiftforward.adstax.spark

import org.apache.spark.SparkConf
import org.apache.spark.serializer.KryoSerializer

/**
 * Main entrypoint for the Spark driver in the AdStax cluster. The name of a class extending `SparkJob` should be
 * supplied as command line argument to the runner (via `--job <class_name>`). This object ensure the context is
 * properly created and closed at the end of the job.
 */
object SparkJobRunner {
  def main(args: Array[String]): Unit = {
    val ji = args.indexOf("--job")
    if (ji == -1 || ji + 1 >= args.size) {
      println("No job specified")
      return
    }
    val job = getClass.getClassLoader.loadClass(args(ji + 1)).newInstance().asInstanceOf[SparkJob]
    val conf = new SparkConf()
      .setAppName(job.name)
      .set("es.index.read.missing.as.empty", "yes")
      .set("spark.serializer", classOf[KryoSerializer].getName)
    implicit val context = new AdStaxSparkContext(conf)
    try {
      job.run(args.drop(ji + 2))
    } finally {
      context.stop()
    }
  }
}
