package eu.shiftforward.adstax.productfeeder.rpc

import spray.json.DefaultJsonProtocol

/**
 * Represents a query for a given product.
 *
 * @param clientId the id of the client
 * @param siteId optinal site id, if none the query will search for the product at a client level
 * @param productId the id of the product
 */
case class ProductQuery(clientId: String, siteId: String, productId: String)

object ProductQuery {
  object JsonProtocol extends DefaultJsonProtocol {
    implicit val productQueryFormat = jsonFormat3(ProductQuery.apply)
  }
}
