package eu.shiftforward.adstax.util

import spray.json._
import spray.json.DefaultJsonProtocol._

object Rpc {
  /**
   * An Error that occurred as a result of a Rpc call. This class exists so that
   * we don't have exceptions as a reply to a Rpc call.
   *
   * @param message the error message
   */
  case class Error(message: String)

  object JsonProtocol {
    implicit val errorJsonFormat: RootJsonFormat[Rpc.Error] = new RootJsonFormat[Rpc.Error] {
      def write(error: Rpc.Error) = JsObject(
        "type" -> JsString("RpcError"),
        "message" -> error.message.toJson)
      def read(json: JsValue) = json match {
        case JsObject(fields) if fields.contains("type") && fields.contains("message") =>
          (fields("type"), fields("message")) match {
            case (JsString("RpcError"), JsString(message)) => Rpc.Error(message)
            case (other, _) => deserializationError("Unexpected type: " + other.toString())
          }
        case other => deserializationError("Expected a JsObject with fields 'type' and 'message', got: " + other)
      }
    }
  }
}
