package eu.shiftforward.adstax.recommender

import spray.json.DefaultJsonProtocol

/**
 * Represents a supported response from the RecommenderActor
 */
sealed trait RecommenderResult

case class GetRecommendationResult(recommendationResult: Option[Recommendation]) extends RecommenderResult

object RecommenderResult {
  object JsonProtocol extends DefaultJsonProtocol {
    import Recommendation.JsonProtocol._

    implicit val getRecommendationResultFormat = jsonFormat1(GetRecommendationResult)
  }
}
