package eu.shiftforward.adstax.recommender

import eu.shiftforward.apso.collection.HMap
import eu.shiftforward.apso.json.{ JsonHMap, JsonHMapKey, JsonKeyRegistry }
import eu.shiftforward.apso.json.JsonHMap.JsonHMap
import spray.json._
import spray.json.DefaultJsonProtocol._

/**
 * A set of features that can be extracted to improve recommendations
 */
class Features(val jsonContainer: JsonHMap) {
  def get[V](feature: Features.FeatureKey[V]): Option[V] = jsonContainer.get(feature)
  def apply[V](feature: Features.FeatureKey[V]): V = jsonContainer.apply(feature)
}

object Features {
  import scala.language.existentials

  object JsonProtocol {
    implicit object FeaturesJsonFormat extends RootJsonFormat[Features] {
      override def write(obj: Features): JsValue = hMapJsonFormat.write(obj.jsonContainer)
      override def read(json: JsValue): Features = new Features(hMapJsonFormat.read(json))
    }
  }

  val jsonRegistry = new JsonKeyRegistry {}

  class FeatureKey[V](symbol: Symbol)(implicit jsonFormat: JsonFormat[V]) extends JsonHMapKey[V](symbol)(jsonRegistry, jsonFormat)

  val timestamp = new FeatureKey[Long]('timestamp)
  val location = new FeatureKey[(Double, Double)]('location)

  def apply(entries: (FeatureKey[V], V) forSome { type V }*): Features =
    new Features(HMap(entries: _*))

  val hMapJsonFormat = JsonHMap.caseJsonFormat(jsonRegistry)
}
