package eu.shiftforward.adstax.storage.rpc

import eu.shiftforward.adstax.storage.UserAttributes
import eu.shiftforward.adstax.storage.UserAttributes.JsonProtocol._
import spray.json.DefaultJsonProtocol._

/**
 * Base trait for user profile storage response messages.
 */
sealed trait UserProfileStorageResponse

/**
 * Companion object containing the definition of the various `UserProfileStorageResponse` types, along with their JSON
 * format.
 */
object UserProfileStorageResponse {

  /**
   * Message received by an user profile storage in response to a `Get` request.
   * @param attributes the value associated the previously requested key wrapped in a `Some` if there is such a value,
   *                   `None` otherwise
   * @param exception an optional error message occurred during the operation
   */
  case class GetResponse(attributes: Option[UserAttributes], exception: Option[String]) extends UserProfileStorageResponse

  /**
   * Message received by an user profile storage in response to a `Update` request.
   * @param success `true` of the operation was successful, `false` otherwise
   * @param exception an optional error message occurred during the operation
   */
  case class UpdateResponse(success: Boolean, exception: Option[String]) extends UserProfileStorageResponse

  /**
   * Message received by an user profile storage in response to a `Delete` request.
   * @param success `true` of the operation was successful, `false` otherwise
   * @param exception an optional error message occurred during the operation
   */
  case class DeleteResponse(success: Boolean, exception: Option[String]) extends UserProfileStorageResponse

  object JsonProtocol {
    /**
     * The JSON format for `GetResponse` messages.
     */
    implicit val getResponseFormat = jsonFormat2(GetResponse)

    /**
     * The JSON format for `PutResponse` messages.
     */
    implicit val updateResponseFormat = jsonFormat2(UpdateResponse)

    /**
     * The JSON format for `DeleteResponse` messages.
     */
    implicit val deleteResponseFormat = jsonFormat2(DeleteResponse)
  }
}
