package eu.shiftforward.adstax.recommender

import akka.actor.ActorRefFactory
import eu.shiftforward.adstax.util.{ RmqRpcJsonClientTypeDescriptor, RmqRpcJsonClient }

trait RecommenderRmqRpcClient extends RmqRpcJsonClient {

  def actorRefFactory: ActorRefFactory
  def rmqActorRefFactory = actorRefFactory

  implicit val typeDescriptor = new RmqRpcJsonClientTypeDescriptor[GetRecommendation, GetRecommendationResult] {}
  implicit val requestRoutingKey = GetRecommendationTypeRoutingKey
  implicit val requestWriter = RecommenderOperation.JsonProtocol.GetRecommendationJsonFormat
  implicit val responseReader = RecommenderResult.JsonProtocol.getRecommendationResultFormat

  def rpcGet(recommendationRequest: GetRecommendation) =
    dispatchRequest[GetRecommendation, GetRecommendationResult](recommendationRequest)
}
