/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.xstream;

import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.xstream.CompilerIndependentOuterClassFieldMapper;
import brooklyn.util.xstream.EnumCaseForgivingConverter;
import brooklyn.util.xstream.ImmutableListConverter;
import brooklyn.util.xstream.ImmutableMapConverter;
import brooklyn.util.xstream.ImmutableSetConverter;
import brooklyn.util.xstream.Inet4AddressConverter;
import brooklyn.util.xstream.MutableSetConverter;
import brooklyn.util.xstream.StringKeyMapConverter;
import com.google.common.collect.ImmutableList;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class XmlSerializer<T> {
    protected final XStream xstream = new XStream(){

        protected MapperWrapper wrapMapper(MapperWrapper next) {
            MapperWrapper result = super.wrapMapper(next);
            return XmlSerializer.this.wrapMapper(result);
        }
    };

    public XmlSerializer() {
        this.xstream.alias("map", Map.class, LinkedHashMap.class);
        this.xstream.alias("set", Set.class, LinkedHashSet.class);
        this.xstream.registerConverter((Converter)new StringKeyMapConverter(this.xstream.getMapper()), 10);
        this.xstream.alias("MutableMap", MutableMap.class);
        this.xstream.alias("MutableSet", MutableSet.class);
        this.xstream.alias("MutableList", MutableList.class);
        this.xstream.registerConverter((Converter)new MutableSetConverter(this.xstream.getMapper()));
        this.xstream.aliasType("ImmutableList", ImmutableList.class);
        this.xstream.registerConverter((Converter)new ImmutableListConverter(this.xstream.getMapper()));
        this.xstream.registerConverter((Converter)new ImmutableSetConverter(this.xstream.getMapper()));
        this.xstream.registerConverter((Converter)new ImmutableMapConverter(this.xstream.getMapper()));
        this.xstream.registerConverter((Converter)new EnumCaseForgivingConverter());
        this.xstream.registerConverter((Converter)new Inet4AddressConverter());
    }

    protected MapperWrapper wrapMapper(MapperWrapper next) {
        return new CompilerIndependentOuterClassFieldMapper((Mapper)next);
    }

    public void serialize(Object object, Writer writer) {
        this.xstream.toXML(object, writer);
    }

    public T deserialize(Reader xml) {
        return (T)this.xstream.fromXML(xml);
    }

    public String toString(T memento) {
        StringWriter writer = new StringWriter();
        this.serialize(memento, writer);
        return ((Object)writer).toString();
    }

    public T fromString(String xml) {
        return this.deserialize(new StringReader(xml));
    }
}

