/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.ReferencingMarshallingContext;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ConcurrentModificationException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapConverter
extends com.thoughtworks.xstream.converters.collections.MapConverter {
    private static final Logger log = LoggerFactory.getLogger(MapConverter.class);

    public MapConverter(Mapper mapper) {
        super(mapper);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Map map = (Map)source;
        try {
            for (Map.Entry entry : map.entrySet()) {
                this.marshalEntry(writer, context, entry);
            }
        }
        catch (ConcurrentModificationException e) {
            log.debug("Map " + (context instanceof ReferencingMarshallingContext ? "at " + ((ReferencingMarshallingContext)context).currentPath() : "") + "[" + source + "] modified while serializing; will fail, and retry may be attempted");
            throw e;
        }
    }

    protected String getEntryNodeName() {
        return this.mapper().serializedClass(Map.Entry.class);
    }

    protected void marshalEntry(HierarchicalStreamWriter writer, MarshallingContext context, Map.Entry entry) {
        ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)this.getEntryNodeName(), Map.Entry.class);
        this.writeItem(entry.getKey(), context, writer);
        this.writeItem(entry.getValue(), context, writer);
        writer.endNode();
    }

    protected void populateMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            this.unmarshalEntry(reader, context, map);
            reader.moveUp();
        }
    }

    protected void unmarshalEntry(HierarchicalStreamReader reader, UnmarshallingContext context, Map map) {
        reader.moveDown();
        Object key = this.readItem(reader, context, map);
        reader.moveUp();
        reader.moveDown();
        Object value = this.readItem(reader, context, map);
        reader.moveUp();
        map.put(key, value);
    }
}

