/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.xstream;

import brooklyn.util.exceptions.Exceptions;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class Inet4AddressConverter
implements Converter {
    public boolean canConvert(Class type) {
        return type.equals(Inet4Address.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Inet4Address addr = (Inet4Address)source;
        writer.setValue(addr.getHostName() + "/" + addr.getHostAddress());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String hostSlashAddress = reader.getValue();
        int i = hostSlashAddress.indexOf(47);
        try {
            if (i == -1) {
                return Inet4Address.getByName(hostSlashAddress);
            }
            String host = hostSlashAddress.substring(0, i);
            String addrS = hostSlashAddress.substring(i + 1);
            byte[] addr = new byte[4];
            String[] addrSI = addrS.split("\\.");
            for (int k = 0; k < 4; ++k) {
                addr[k] = (byte)Integer.valueOf(addrSI[k]).intValue();
            }
            return Inet4Address.getByAddress(host, addr);
        }
        catch (UnknownHostException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

