/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.xstream;

import brooklyn.util.exceptions.Exceptions;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.enums.EnumConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

public class EnumCaseForgivingConverter
extends EnumConverter {
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class type = context.getRequiredType();
        if (type.getSuperclass() != Enum.class) {
            type = type.getSuperclass();
        }
        String token = reader.getValue();
        return EnumCaseForgivingConverter.resolve(type, token);
    }

    public static <T extends Enum<T>> T resolve(Class<T> type, String token) {
        try {
            return Enum.valueOf(type, token.toUpperCase());
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            try {
                for (Enum v : (Enum[])type.getEnumConstants()) {
                    if (!v.name().equalsIgnoreCase(token)) continue;
                    return (T)v;
                }
                throw e;
            }
            catch (Exception e2) {
                throw Exceptions.propagate((Throwable)e2);
            }
        }
    }
}

