/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task.system.internal;

import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.internal.ssh.ShellTool;
import brooklyn.util.internal.ssh.process.ProcessTool;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.task.system.internal.AbstractProcessTaskFactory;
import brooklyn.util.task.system.internal.ExecWithLoggingHelpers;
import com.google.common.base.Function;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemProcessTaskFactory<T extends SystemProcessTaskFactory<T, RET>, RET>
extends AbstractProcessTaskFactory<T, RET> {
    private static final Logger log = LoggerFactory.getLogger(SystemProcessTaskFactory.class);
    private File directory;
    private Boolean loginShell;

    public SystemProcessTaskFactory(String ... commands) {
        super(commands);
    }

    public T directory(File directory) {
        this.markDirty();
        this.directory = directory;
        return (T)((SystemProcessTaskFactory)this.self());
    }

    public T loginShell(boolean loginShell) {
        this.markDirty();
        this.loginShell = loginShell;
        return (T)((SystemProcessTaskFactory)this.self());
    }

    @Override
    public T machine(SshMachineLocation machine) {
        log.warn("Not permitted to set machines on " + this + " (ignoring - " + machine + ")");
        if (log.isDebugEnabled()) {
            log.debug("Source of attempt to set machines on " + this + " (" + machine + ")", new Throwable("Source of attempt to set machines on " + this + " (" + machine + ")"));
        }
        return (T)((SystemProcessTaskFactory)this.self());
    }

    public ProcessTaskWrapper<RET> newTask() {
        return new SystemProcessTaskWrapper();
    }

    protected ExecWithLoggingHelpers newExecWithLoggingHelpers() {
        return new ExecWithLoggingHelpers("Process"){

            protected <U> U execWithTool(MutableMap<String, Object> props, Function<ShellTool, U> task) {
                if (log.isDebugEnabled() && props != null && !props.isEmpty()) {
                    log.debug("Ignoring flags " + props + " when running " + this);
                }
                return (U)task.apply((Object)new ProcessTool());
            }

            @Override
            protected void preExecChecks() {
            }

            @Override
            protected String constructDefaultLoggingPrefix(ConfigBag execFlags) {
                return "system.exec";
            }

            @Override
            protected String getTargetName() {
                return "local host";
            }
        }.logger(log);
    }

    public static class ConcreteSystemProcessTaskFactory<RET>
    extends SystemProcessTaskFactory<ConcreteSystemProcessTaskFactory<RET>, RET> {
        public ConcreteSystemProcessTaskFactory(String ... commands) {
            super(commands);
        }
    }

    protected class SystemProcessTaskWrapper
    extends ProcessTaskWrapper<RET> {
        protected final String taskTypeShortName;

        public SystemProcessTaskWrapper() {
            this("Process");
        }

        public SystemProcessTaskWrapper(String taskTypeShortName) {
            super(SystemProcessTaskFactory.this);
            this.taskTypeShortName = taskTypeShortName;
        }

        @Override
        protected ConfigBag getConfigForRunning() {
            ConfigBag result = super.getConfigForRunning();
            if (SystemProcessTaskFactory.this.directory != null) {
                this.config.put(ProcessTool.PROP_DIRECTORY, SystemProcessTaskFactory.this.directory.getAbsolutePath());
            }
            if (SystemProcessTaskFactory.this.loginShell != null) {
                this.config.put(ProcessTool.PROP_LOGIN_SHELL, SystemProcessTaskFactory.this.loginShell);
            }
            return result;
        }

        @Override
        protected void run(ConfigBag config) {
            this.exitCode = Boolean.FALSE.equals(this.runAsScript) ? Integer.valueOf(SystemProcessTaskFactory.this.newExecWithLoggingHelpers().execCommands(config.getAllConfig(), this.getSummary(), this.getCommands(), this.getShellEnvironment())) : Integer.valueOf(SystemProcessTaskFactory.this.newExecWithLoggingHelpers().execScript(config.getAllConfig(), this.getSummary(), this.getCommands(), this.getShellEnvironment()));
        }

        @Override
        protected String taskTypeShortName() {
            return this.taskTypeShortName;
        }
    }
}

