/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task.system.internal;

import brooklyn.config.ConfigKey;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.internal.ssh.ShellAbstractTool;
import brooklyn.util.internal.ssh.ShellTool;
import brooklyn.util.stream.StreamGobbler;
import brooklyn.util.stream.Streams;
import brooklyn.util.task.Tasks;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public abstract class ExecWithLoggingHelpers {
    public static final ConfigKey<OutputStream> STDOUT = SshMachineLocation.STDOUT;
    public static final ConfigKey<OutputStream> STDERR = SshMachineLocation.STDERR;
    public static final ConfigKey<Boolean> NO_STDOUT_LOGGING = SshMachineLocation.NO_STDOUT_LOGGING;
    public static final ConfigKey<Boolean> NO_STDERR_LOGGING = SshMachineLocation.NO_STDERR_LOGGING;
    public static final ConfigKey<String> LOG_PREFIX = SshMachineLocation.LOG_PREFIX;
    protected final String shortName;
    protected Logger commandLogger = null;

    protected abstract <T> T execWithTool(MutableMap<String, Object> var1, Function<ShellTool, T> var2);

    protected abstract void preExecChecks();

    protected abstract String getTargetName();

    protected abstract String constructDefaultLoggingPrefix(ConfigBag var1);

    public ExecWithLoggingHelpers(String shortName) {
        this.shortName = shortName;
    }

    public ExecWithLoggingHelpers logger(Logger commandLogger) {
        this.commandLogger = commandLogger;
        return this;
    }

    public int execScript(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        String scriptHeader = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_SCRIPT_HEADER);
        return this.execWithLogging(props, summaryForLogging, commands, env, scriptHeader, new ExecRunner(){

            @Override
            public int exec(ShellTool ssh, Map<String, ?> flags, List<String> cmds, Map<String, ?> env) {
                return ssh.execScript(flags, cmds, env);
            }
        });
    }

    protected static <T> T getOptionalVal(Map<String, ?> map, ConfigKey<T> keyC) {
        if (keyC == null) {
            return null;
        }
        String key = keyC.getName();
        if (map != null && map.containsKey(key)) {
            return TypeCoercions.coerce(map.get(key), keyC.getTypeToken());
        }
        return (T)keyC.getDefaultValue();
    }

    public int execCommands(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        return this.execWithLogging(props, summaryForLogging, commands, env, new ExecRunner(){

            @Override
            public int exec(ShellTool tool, Map<String, ?> flags, List<String> cmds, Map<String, ?> env) {
                return tool.execCommands(flags, cmds, env);
            }
        });
    }

    public int execWithLogging(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env, ExecRunner execCommand) {
        return this.execWithLogging(props, summaryForLogging, commands, env, null, execCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execWithLogging(Map<String, ?> props, final String summaryForLogging, final List<String> commands, final Map<String, ?> env, String expectedCommandHeaders, final ExecRunner execCommand) {
        if (this.commandLogger != null && this.commandLogger.isDebugEnabled()) {
            String allcmds = (Strings.isBlank((CharSequence)expectedCommandHeaders) ? "" : expectedCommandHeaders + " ; ") + Strings.join(commands, (String)" ; ");
            this.commandLogger.debug("{}, initiating " + this.shortName.toLowerCase() + " on machine {}{}: {}", new Object[]{summaryForLogging, this.getTargetName(), env != null && !env.isEmpty() ? " (env " + env + ")" : "", allcmds});
        }
        if (commands.isEmpty()) {
            if (this.commandLogger != null && this.commandLogger.isDebugEnabled()) {
                this.commandLogger.debug("{}, on machine {}, ending: no commands to run", (Object)summaryForLogging, (Object)this.getTargetName());
            }
            return 0;
        }
        final ConfigBag execFlags = new ConfigBag().putAll(props);
        ConfigBag toolFlags = new ConfigBag().putAll(props).removeAll(LOG_PREFIX, STDOUT, STDERR, ShellTool.PROP_NO_EXTRA_OUTPUT);
        execFlags.configure(ShellTool.PROP_SUMMARY, summaryForLogging);
        PipedOutputStream outO = null;
        PipedOutputStream outE = null;
        StreamGobbler gO = null;
        StreamGobbler gE = null;
        try {
            int n;
            this.preExecChecks();
            String logPrefix = execFlags.get(LOG_PREFIX);
            if (logPrefix == null) {
                logPrefix = this.constructDefaultLoggingPrefix(execFlags);
            }
            if (!execFlags.get(NO_STDOUT_LOGGING).booleanValue()) {
                PipedInputStream insO = new PipedInputStream();
                outO = new PipedOutputStream(insO);
                String stdoutLogPrefix = "[" + (logPrefix != null ? logPrefix + ":stdout" : "stdout") + "] ";
                gO = new StreamGobbler((InputStream)insO, execFlags.get(STDOUT), this.commandLogger).setLogPrefix(stdoutLogPrefix);
                gO.start();
                execFlags.put(STDOUT, outO);
            }
            if (!execFlags.get(NO_STDERR_LOGGING).booleanValue()) {
                PipedInputStream insE = new PipedInputStream();
                outE = new PipedOutputStream(insE);
                String stderrLogPrefix = "[" + (logPrefix != null ? logPrefix + ":stderr" : "stderr") + "] ";
                gE = new StreamGobbler((InputStream)insE, execFlags.get(STDERR), this.commandLogger).setLogPrefix(stderrLogPrefix);
                gE.start();
                execFlags.put(STDERR, outE);
            }
            Tasks.setBlockingDetails(this.shortName + " executing, " + summaryForLogging);
            try {
                n = this.execWithTool((MutableMap<String, Object>)MutableMap.copyOf(toolFlags.getAllConfig()), new Function<ShellTool, Integer>(){

                    public Integer apply(ShellTool tool) {
                        int result = execCommand.exec(tool, (Map<String, ?>)MutableMap.copyOf(execFlags.getAllConfig()), commands, env);
                        if (ExecWithLoggingHelpers.this.commandLogger != null && ExecWithLoggingHelpers.this.commandLogger.isDebugEnabled()) {
                            ExecWithLoggingHelpers.this.commandLogger.debug("{}, on machine {}, completed: return status {}", new Object[]{summaryForLogging, ExecWithLoggingHelpers.this.getTargetName(), result});
                        }
                        return result;
                    }
                });
            }
            catch (Throwable throwable) {
                try {
                    Tasks.setBlockingDetails(null);
                    throw throwable;
                }
                catch (IOException e) {
                    if (this.commandLogger != null && this.commandLogger.isDebugEnabled()) {
                        this.commandLogger.debug("{}, on machine {}, failed: {}", new Object[]{summaryForLogging, this.getTargetName(), e});
                    }
                    throw Throwables.propagate((Throwable)e);
                }
            }
            Tasks.setBlockingDetails(null);
            return n;
        }
        finally {
            if (outO != null) {
                try {
                    outO.flush();
                }
                catch (IOException e) {}
            }
            if (outE != null) {
                try {
                    outE.flush();
                }
                catch (IOException e) {}
            }
            Streams.closeQuietly((Closeable)outO);
            Streams.closeQuietly((Closeable)outE);
            try {
                if (gE != null) {
                    gE.join();
                }
                if (gO != null) {
                    gO.join();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Throwables.propagate((Throwable)e);
            }
        }
    }

    public static interface ExecRunner {
        public int exec(ShellTool var1, Map<String, ?> var2, List<String> var3, Map<String, ?> var4);
    }
}

