/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task.system.internal;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.stream.Streams;
import brooklyn.util.task.TaskBuilder;
import brooklyn.util.task.system.ProcessTaskFactory;
import brooklyn.util.task.system.ProcessTaskStub;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessTaskFactory<T extends AbstractProcessTaskFactory<T, RET>, RET>
extends ProcessTaskStub
implements ProcessTaskFactory<RET> {
    private static final Logger log = LoggerFactory.getLogger(AbstractProcessTaskFactory.class);
    protected boolean dirty = false;

    public AbstractProcessTaskFactory(String ... commands) {
        this.commands.addAll(Arrays.asList(commands));
    }

    protected T self() {
        return (T)this;
    }

    protected void markDirty() {
        this.dirty = true;
    }

    public T add(String ... commandsToAdd) {
        this.markDirty();
        for (String commandToAdd : commandsToAdd) {
            this.commands.add(commandToAdd);
        }
        return this.self();
    }

    public T add(Iterable<String> commandsToAdd) {
        Iterables.addAll((Collection)this.commands, commandsToAdd);
        return this.self();
    }

    public T machine(SshMachineLocation machine) {
        this.markDirty();
        this.machine = machine;
        return this.self();
    }

    public T requiringExitCodeZero() {
        this.markDirty();
        this.requireExitCodeZero = true;
        return this.self();
    }

    public T requiringExitCodeZero(String extraErrorMessage) {
        this.markDirty();
        this.requireExitCodeZero = true;
        this.extraErrorMessage = extraErrorMessage;
        return this.self();
    }

    public T allowingNonZeroExitCode() {
        this.markDirty();
        this.requireExitCodeZero = false;
        return this.self();
    }

    @Override
    public ProcessTaskFactory<Boolean> returningIsExitCodeZero() {
        if (this.requireExitCodeZero == null) {
            this.allowingNonZeroExitCode();
        }
        return this.returning(new Function<ProcessTaskWrapper<?>, Boolean>(){

            public Boolean apply(ProcessTaskWrapper<?> input) {
                return input.getExitCode() == 0;
            }
        });
    }

    @Override
    public ProcessTaskFactory<String> requiringZeroAndReturningStdout() {
        this.requiringExitCodeZero();
        return this.returning(ProcessTaskStub.ScriptReturnType.STDOUT_STRING);
    }

    @Override
    public <RET2> ProcessTaskFactory<RET2> returning(ProcessTaskStub.ScriptReturnType type) {
        this.markDirty();
        this.returnType = (ProcessTaskStub.ScriptReturnType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        return this.self();
    }

    @Override
    public <RET2> ProcessTaskFactory<RET2> returning(Function<ProcessTaskWrapper<?>, RET2> resultTransformation) {
        this.markDirty();
        this.returnType = ProcessTaskStub.ScriptReturnType.CUSTOM;
        this.returnResultTransformation = resultTransformation;
        return this.self();
    }

    public T runAsCommand() {
        this.markDirty();
        this.runAsScript = false;
        return this.self();
    }

    public T runAsScript() {
        this.markDirty();
        this.runAsScript = true;
        return this.self();
    }

    public T runAsRoot() {
        this.markDirty();
        this.runAsRoot = true;
        return this.self();
    }

    public T environmentVariable(String key, String val) {
        this.markDirty();
        this.shellEnvironment.put(key, val);
        return this.self();
    }

    public T environmentVariables(Map<String, String> vars) {
        if (vars != null) {
            this.markDirty();
            this.shellEnvironment.putAll(vars);
        }
        return this.self();
    }

    public TaskBuilder<Object> constructCustomizedTaskBuilder() {
        TaskBuilder<Object> tb = TaskBuilder.builder().dynamic(false).name("ssh: " + this.getSummary());
        tb.tag(BrooklynTaskTags.tagForStream("stdin", Streams.byteArrayOfString((String)Strings.join((Iterable)this.commands, (String)"\n"))));
        tb.tag(BrooklynTaskTags.tagForEnvStream("env", this.shellEnvironment));
        return tb;
    }

    public T summary(String summary) {
        this.markDirty();
        this.summary = summary;
        return this.self();
    }

    public <V> T configure(ConfigKey<V> key, V value) {
        this.config.configure(key, value);
        return this.self();
    }

    public T configure(Map<?, ?> flags) {
        if (flags != null) {
            this.config.putAll(flags);
        }
        return this.self();
    }

    public T addCompletionListener(Function<ProcessTaskWrapper<?>, Void> listener) {
        this.completionListeners.add(listener);
        return this.self();
    }

    protected void finalize() throws Throwable {
        if (this.dirty) {
            log.warn("Task " + this + " was modified but modification was never used");
        }
        super.finalize();
    }
}

