/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.task.system;

import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.management.Task;
import brooklyn.management.TaskWrapper;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.internal.ssh.ShellTool;
import brooklyn.util.stream.Streams;
import brooklyn.util.task.TaskBuilder;
import brooklyn.util.task.Tasks;
import brooklyn.util.task.system.ProcessTaskStub;
import brooklyn.util.task.system.internal.AbstractProcessTaskFactory;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessTaskWrapper<RET>
extends ProcessTaskStub
implements TaskWrapper<RET> {
    private static final Logger log = LoggerFactory.getLogger(ProcessTaskWrapper.class);
    private final Task<RET> task;
    protected ByteArrayOutputStream stdout = new ByteArrayOutputStream();
    protected ByteArrayOutputStream stderr = new ByteArrayOutputStream();
    protected Integer exitCode = null;

    protected ProcessTaskWrapper(AbstractProcessTaskFactory<?, RET> constructor) {
        super(constructor);
        TaskBuilder<Object> tb = constructor.constructCustomizedTaskBuilder();
        if (this.stdout != null) {
            tb.tag(BrooklynTaskTags.tagForStreamSoft("stdout", this.stdout));
        }
        if (this.stderr != null) {
            tb.tag(BrooklynTaskTags.tagForStreamSoft("stderr", this.stderr));
        }
        this.task = tb.body(new ProcessTaskInternalJob()).build();
    }

    public Task<RET> asTask() {
        return this.getTask();
    }

    public Task<RET> getTask() {
        return this.task;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public byte[] getStdoutBytes() {
        if (this.stdout == null) {
            return null;
        }
        return this.stdout.toByteArray();
    }

    public byte[] getStderrBytes() {
        if (this.stderr == null) {
            return null;
        }
        return this.stderr.toByteArray();
    }

    public String getStdout() {
        if (this.stdout == null) {
            return null;
        }
        return this.stdout.toString();
    }

    public String getStderr() {
        if (this.stderr == null) {
            return null;
        }
        return this.stderr.toString();
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.task + "]";
    }

    public RET get() {
        return (RET)this.getTask().getUnchecked();
    }

    public ProcessTaskWrapper<RET> block() {
        this.getTask().blockUntilEnded();
        return this;
    }

    public boolean isDone() {
        return this.getTask().isDone();
    }

    protected ConfigBag getConfigForRunning() {
        ConfigBag config = ConfigBag.newInstanceCopying(this.config);
        if (this.stdout != null) {
            config.put(ShellTool.PROP_OUT_STREAM, this.stdout);
        }
        if (this.stderr != null) {
            config.put(ShellTool.PROP_ERR_STREAM, this.stderr);
        }
        if (!config.containsKey(ShellTool.PROP_NO_EXTRA_OUTPUT)) {
            config.put(ShellTool.PROP_NO_EXTRA_OUTPUT, true);
        }
        if (this.runAsRoot) {
            config.put(ShellTool.PROP_RUN_AS_ROOT, true);
        }
        return config;
    }

    protected abstract void run(ConfigBag var1);

    protected abstract String taskTypeShortName();

    protected class ProcessTaskInternalJob
    implements Callable<Object> {
        protected ProcessTaskInternalJob() {
        }

        @Override
        public Object call() throws Exception {
            ProcessTaskWrapper.this.run(ProcessTaskWrapper.this.getConfigForRunning());
            for (Function listener : ProcessTaskWrapper.this.completionListeners) {
                try {
                    listener.apply((Object)ProcessTaskWrapper.this);
                }
                catch (Exception e) {
                    this.logWithDetailsAndThrow("Error in " + ProcessTaskWrapper.this.taskTypeShortName() + " task " + ProcessTaskWrapper.this.getSummary() + ": " + e, e);
                }
            }
            if (ProcessTaskWrapper.this.exitCode != 0 && !Boolean.FALSE.equals(ProcessTaskWrapper.this.requireExitCodeZero)) {
                if (Boolean.TRUE.equals(ProcessTaskWrapper.this.requireExitCodeZero)) {
                    this.logWithDetailsAndThrow(ProcessTaskWrapper.this.taskTypeShortName() + " task ended with exit code " + ProcessTaskWrapper.this.exitCode + " when 0 was required, in " + Tasks.current() + ": " + ProcessTaskWrapper.this.getSummary(), null);
                } else {
                    log.warn(ProcessTaskWrapper.this.taskTypeShortName() + " task ended with exit code " + ProcessTaskWrapper.this.exitCode + " when non-zero was not explicitly allowed (error may be thrown in future), in " + Tasks.current() + ": " + ProcessTaskWrapper.this.getSummary());
                }
            }
            switch (ProcessTaskWrapper.this.returnType) {
                case CUSTOM: {
                    return ProcessTaskWrapper.this.returnResultTransformation.apply((Object)ProcessTaskWrapper.this);
                }
                case STDOUT_STRING: {
                    return ProcessTaskWrapper.this.stdout.toString();
                }
                case STDOUT_BYTES: {
                    return ProcessTaskWrapper.this.stdout.toByteArray();
                }
                case STDERR_STRING: {
                    return ProcessTaskWrapper.this.stderr.toString();
                }
                case STDERR_BYTES: {
                    return ProcessTaskWrapper.this.stderr.toByteArray();
                }
                case EXIT_CODE: {
                    return ProcessTaskWrapper.this.exitCode;
                }
            }
            throw new IllegalStateException("Unknown return type for " + ProcessTaskWrapper.this.taskTypeShortName() + " job " + ProcessTaskWrapper.this.getSummary() + ": " + (Object)((Object)ProcessTaskWrapper.this.returnType));
        }

        protected void logWithDetailsAndThrow(String message, Throwable optionalCause) {
            message = (ProcessTaskWrapper.this.extraErrorMessage != null ? ProcessTaskWrapper.this.extraErrorMessage + ": " : "") + message;
            log.warn(message + " (throwing)");
            this.logProblemDetails("STDERR", ProcessTaskWrapper.this.stderr, 1024);
            this.logProblemDetails("STDOUT", ProcessTaskWrapper.this.stdout, 1024);
            this.logProblemDetails("STDIN", Streams.byteArrayOfString((String)Strings.join((Iterable)ProcessTaskWrapper.this.commands, (String)"\n")), 4096);
            if (optionalCause != null) {
                throw new IllegalStateException(message, optionalCause);
            }
            throw new IllegalStateException(message);
        }

        protected void logProblemDetails(String streamName, ByteArrayOutputStream stream, int max) {
            Streams.logStreamTail((Logger)log, (String)(streamName + " for problem in " + Tasks.current()), (ByteArrayOutputStream)stream, (int)max);
        }
    }
}

